﻿<%@ Page Title="Lab Orders" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="LabOrders.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.LabOrders" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    <script type ="text/javascript">

        $(document).ready(function()
        {
            if ($('select.criteria').length > 0)
            {
                if ($('select.criteria').find(":selected").val() == "")
                {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#<%= ButtonClear.ClientID %>').attr('disabled', 'disabled');
                }
                else
                {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#<%= ButtonClear.ClientID %>').removeAttr('disabled');
                }
            }

            $('select.criteria').change(function()
            {
                $('#<%= TextBoxSearchCriteria.ClientID %>').val('');

                if ($(this).val() == "")
                {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#<%= ButtonClear.ClientID %>').attr('disabled', 'disabled');
                }
                else
                {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#<%= ButtonClear.ClientID %>').removeAttr('disabled');
                }
            });
            
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();
        });
    </script>

    <br />

    <div class = "excludeSaveWarnings">
        <asp:Label SkinID="DataLabel" ID="LabelSearchCriteria" runat="server" 
            AssociatedControlID="TextBoxSearchCriteria">
            Filter by Last Name:
        </asp:Label>
        <asp:DropDownList ID="DropDownFilterBy" runat="server"
            visible="false" CssClass = "criteria">
            <asp:ListItem Selected="True" 
                Text="(Select value)" 
                value="">
            </asp:ListItem>
            <asp:ListItem 
                Text="Patient Name" 
                value="PatientName">
            </asp:ListItem>
            <asp:ListItem 
                Text="BSO Number" 
                value="BSONumber">
            </asp:ListItem>
            <asp:ListItem 
                Text="Lab Request Number" 
                value="LabRequestId">
            </asp:ListItem>
        </asp:DropDownList>
         
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click" />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" />
        <br />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    </div>    

    <br />
    <br />

    <asp:GridView ID = "GridViewEFRLabOrders" runat = "server"  DataSourceID = "ObjectDataSourceEFRLabOrdersMultipleSearch"  AutoGenerateColumns = "false"
        AllowPaging="True"  PageSize="20" DataKeyNames = "LabOrderId" OnRowCommand = "LabOrders_RowCommand" AllowSorting = "true"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
        <EmptyDataTemplate>
            No lab orders matching selection criteria exist in this status
        </EmptyDataTemplate> 
        <Columns>
            <asp:TemplateField 
                HeaderText = "Workflow ID" 
                SortExpression = "CaseId" 
                ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelCaseID" runat = "server" 
                        Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CaseId"))) %>' ></asp:Label> 
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText = "Lab Request Number" 
                ItemStyle-HorizontalAlign="Center" 
                SortExpression = "LabRequestId">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRequestID" runat = "server" 
                        Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LabRequestIdNumber"))) %>' >
                    </asp:Label> 
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Patient Name" 
                SortExpression = "PatientName">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientName"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
             <asp:TemplateField 
                HeaderText="Site Number" 
                SortExpression = "StationNumber">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("StationNumber"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
             <asp:TemplateField 
                HeaderText="Facility" 
                SortExpression = "Institution">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Institution"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Lab Request Date" 
                SortExpression = "RequestDate" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelLabRequestDate" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("RequestDate", "{0:d}"))) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Date Received by Metals Lab" 
                SortExpression = "ReceivedByMetalsLabDate" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelDateReceivedByMetalsLab" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReceivedByMetalsLabDate", "{0:d}"))) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField  
                HeaderText="Lab Report Date" 
                SortExpression = "ReportDate" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelLabReportDate" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReportDate", "{0:d}"))) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Status" 
                SortExpression = "LabOrderStatus">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelOrderStatus" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LabOrderStatus"))) %>' >
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Specimen Type" SortExpression = "LabOrderType">
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelOrderType" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LabOrderType"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="BSO Number" SortExpression = "BSONumber">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelBSONumber" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("BSONumber"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>    

    <asp:ObjectDataSource ID="ObjectDataSourceEFRLabOrdersMultipleSearch" runat="server"  SelectMethod="SelectByStatus"  
        OnSelecting="Ds_Selecting" SelectCountMethod="SelectByStatusCount"  StartRowIndexParameterName="startRow"  MaximumRowsParameterName="maxRows"  
        SortParameterName="sort" EnablePaging="True" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager">
        <SelectParameters>
            <asp:ControlParameter 
                Name = "searchCriteria" 
                ControlID = "DropDownFilterBy" 
                DefaultValue = "LastName" PropertyName="SelectedValue" />
            <asp:ControlParameter 
                Name = "searchValue" 
                ControlID = "TextBoxSearchCriteria" 
                DefaultValue = "" />
            <asp:QueryStringParameter 
                Name = "id" 
                QueryStringField = "statusId" 
                DefaultValue="1" /> 
        </SelectParameters>         
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID = "ObjectDataSourceEFRLabOrderStatus" runat = "server" OnSelecting="Ds_Selecting" SelectMethod = "STD_WKFACTIVITYSTS_GET" TypeName = "VIRP_WEB.BaseCode.ServiceInterfaceManager">
        <SelectParameters>
            <asp:QueryStringParameter Name = "id" QueryStringField = "statusId" DefaultValue="0" /> 
        </SelectParameters>
   </asp:ObjectDataSource> 
</asp:Content>
